$(document).ready(function() {
	
	if ($("#comboTerritorio010").length > 0){
		$("#comboTerritorio010").rup_combo({
			source: "/ab03bAmiantoWar/ab03bNora/comboProvincia",
			sourceParam : {label:"desc"+$.rup_utils.capitalizedLang(), value:"code", style:"css"},
			width: 300,
			rowStriping:true,
			inputText:true,
			ordered:true,
			blank:"0"
		});
	}
	
	$("#fDesde").rup_date();
	$("#fHasta").rup_date();
	
	jQuery.validator.addMethod("validacionFechas", function(value, element, params) {
		var fechaDesde=$("#fDesde").val();
		var fechaHasta=$("#fHasta").val();
		if(fechaDesde!=''&&fechaHasta!=''){
			fechaDesde=new Date(fechaDesde.substring(6,10),fechaDesde.substring(3,5),fechaDesde.substring(0,2));
			fechaHasta=new Date(fechaHasta.substring(6,10),fechaHasta.substring(3,5),fechaHasta.substring(0,2));
			if(fechaDesde>fechaHasta){
				return false;
			}else{
				return true;
			}
		}else{
			return true;
		}
		
	});	
	
	$("#estadisticas").rup_table({
		url: "../estadisticas/buscarEstado",
		hasMaint: false,
		colNames: [
			$.rup.i18n.app.estadisticas.tipoPlan,
			$.rup.i18n.app.estadisticas.actividad,
			$.rup.i18n.app.estadisticas.expediente,
			$.rup.i18n.app.mantenimientos.provincia, 
			$.rup.i18n.app.estadisticas.mes, 
            $.rup.i18n.app.estadisticas.fecha
		],
		colModel: [
		{
			width:20,
			name: "tipoPlan", 
			label: $.rup.i18n.app.estadisticas.tipoPlan, 
			sortable:true,
			formatter : function(cellval, opts, rwd, act) {
				return rwd.tipoPlanStr;
			}
		},
		{
			width: 30,
			name: "actividad",
			label: $.rup.i18n.app.estadisticas.actividad,
			sortable: true
		},
		{
			width : 20,
			name : "expediente",
			label : $.rup.i18n.app.estadisticas.expediente,
			sortable : true
		},
		{
			width : 20,
			name : "provinciaStrEs",
			label : $.rup.i18n.app.mantenimientos.provincia,
			sortable : true
		},
		{
			width : 20,
			name : "nombreMes",
			label : $.rup.i18n.app.estadisticas.mes,
			sortable : true
		},
		{
			width : 20,
			name : "fechaString",
			label : $.rup.i18n.app.estadisticas.fecha,
			sortable : true,
			ruptype: "datepicker"
		}
		],
		model:"Ab03bEstadisticasBusqueda",
        usePlugins:[
			"feedback",
			"toolbar",
        	"fluid",
        	"filter",
        	"report"
        ],
        primaryKey: "tipoPlan",
		sortname: "expediente",
		sortorder: "asc",
		loadOnStartUp: true,
		rowNum:10,		
        toolbar:{
        	createDefaultToolButtons:false,
        	buttons:[]
        },
		feedback:{
			config:{
				block: false
			}
		},
		report: {
			buttons: [
				{
					 'id': 'reports',
					 'i18nCaption': $.rup.i18n.app.botones.informes,
					 right: true,
					 'buttons': [
					     { 'i18nCaption': 'XLS', 'css': 'xls', 'url': '../estadisticas/xlsReport' },
					     { 'i18nCaption': 'XLSX', 'css': 'xls', 'url': '../estadisticas/xlsxReport' },
					     { 'i18nCaption': 'PDF', 'css': 'pdf', 'url': '../estadisticas/pdfReport?tipo=INSHT' }
					 ]
				}
			]
		}
	});
	
	$("#formHttpSubmit_button_excel").bind("click",function(e){
		if ($('#estadisticas_filter_form').validate().checkForm()) {
			if ($("#comboTerritorio010").length > 0){
				document.getElementById("territorio0102").value = document.getElementById("comboTerritorio010").value;
			} else {
				document.getElementById("territorio0102").value = document.getElementById("hiddenTerritorio010").value;
			}
			document.getElementById("fDesde2").value = document.getElementById("fDesde").value;
			document.getElementById("fHasta2").value = document.getElementById("fHasta").value;
			$('#formHttpSubmit').submit();
		}
	});
	
	$("#estadisticas_filter_form").rup_validate({
		feedback:$("#estadisticas_feedback"),
		liveCheckingErrors: false,
		rules:{
			'fDesde': { date: true, validacionFechas:true },
			'fHasta': { date: true, validacionFechas:true }
		}
	});	
	
	$("#estadisticas").on("rupTable_beforeFilter",
		function(){
			if(ab03bUtils.form.validate($("#estadisticas_filter_form"))){	
				return true;
			} else {
				return false;
			}
		}
	);	
});

//Funcion limpiar
$('#estadisticas_filter_cleanLink').click(function(event){
	resetFiltro($("#estadisticas_filter_form"));
	
	//se borran los mensajes de errores que se muestran en el feedback
	$("#estadisticas_filter_form").validate().submitted = {};
	//se cierra el feedback
	$("#estadisticas_feedback").rup_feedback("close");
	
	$("#estadisticas").rup_table('filter'); 
	
	// se quitan las imagenes que marcan el error
	$(".rup-maint_validateIcon", $("#estadisticas_filter_form")).remove();
	
	
});